#ifndef LLF_ECPKI_ECDSA_H
#define LLF_ECPKI_ECDSA_H

/*
* All the includes that are needed for code using this module to
* Compile correctly should be #included here.
*/

#include "CE2_public.h"
#include "CE2_HASH.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*
* Creation date : Tues Mar 03 09:00:00 2007
* Last modified : %modify_time%
*/
/** @file
* \brief This file contains declaration of low level function
* for ECC signature function, which worked with 
* LibTomCrypt. 
*
* \version LLF_ECPKI_ECDSA.h#1:csrc:1
* \author Yermalayeu Ihar
* \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
* All Rights reserved
*/

/************************ Defines *****************************/
/************************ Enums *******************************/
/************************ Typedefs ****************************/
/************************ Structs *****************************/
/************************ Public Variables ********************/
/************************ Public Functions ********************/

/**
****************************************************************
* Function Name: 
*  LLF_ECDSA_Sign
*
* Inputs:
* @param SignerPrivKey_ptr [in] - A pointer to a user private key structure.    				
* @param HashMode [in] - The enumerator variable defines hash function to be used.                         
* @param MessageDataIn_ptr [in] - A message data for calculation of hash.   			
* @param MessageSizeInBytes [in] - A size of block of message data in bytes. 
* @param SignatureOut_ptr [out] - A pointer to a buffer for output of signature.                         
* @param SignatureOutSize_ptr [in] - Size of user passed buffer for signature (in)
*                         and size of actual signature (out).
* @param IsEphemerKeyInternal [in] - A parameter defining whether ephemeral 
*                         key internal or external
* @param EphemerPublKeyIn_ptr [in] - A pointer to ephemeral public key.
* @param EphemerPublKeySizeBytes [in] - A size (in bytes) of sender's ephemeral 
*                            public key data.
*
* Outputs:
* @returns \b CE2Error_t 
*  - CE2_OK - on success
*  - Otherwise - error code:
*
* \brief \b 
* Description:
*  Performs all of the ECDSA signing operations simultaneously.
*
* \b 
* Algorithm:
*  -# Create digest for input massage data
*  -# Create and initialize Pseudo-Random Number Generators
*  -# Initialization of LibTomCrypt primitives
*  -# Convert digest to little-endian form
*  -# Make up a key and export the public copy
*  -# Build output signature
***************************************************************/
CE2Error_t LLF_ECDSA_Sign(
	CE2_ECPKI_UserPrivKey_t      *SignerPrivKey_ptr,       /*in*/
	CE2_ECPKI_HASH_OpMode_t       HashMode,                /*in*/
	DxUint8_t                     *MessageDataIn_ptr,       /*in*/ 
	DxUint32_t                     MessageSizeInBytes,      /*in*/
	DxUint8_t                     *SignatureOut_ptr,        /*out*/ 
	DxUint32_t                    *SignatureOutSize_ptr,     /*in*/
	DxInt8_t                      IsEphemerKeyInternal,    /*in*/
	DxUint8_t                     *EphemerPublKeyIn_ptr,    /*in*/ 
	DxUint32_t                     EphemerPublKeySizeBytes /*in*/);

/**
****************************************************************
* Function Name: 
*  LLF_ECDSA_Verify
*
* Inputs:
* @param UserPublKey_ptr [in] - A pointer to a user public key structure.
* @param HashMode [in] - The enumerator variable defines the hash function to be used.
* @param MessageDataIn_ptr [in] - Message data for calculating hash.   			
* @param MessageSizeInBytes [in] - Size of block of message data in bytes.       
* @param SignatureIn_ptr [in] - A pointer to a buffer for output of signature. 
* @param SignatureSizeBytes [in] - Size of signature, in bytes
*
* Outputs:
* @returns \b CE2Error_t 
*  - CE2_OK - on success
*  - Otherwise - error code:
*
* \brief \b 
* Description:
*  Performs all of the ECDSA verifying operations simultaneously.
*
* \b 
* Algorithm:
*  -# Create digest for input massage data
*  -# Initialization of LibTomCrypt primitives
*  -# Convert digest to little-endian form
*  -# Read signature value
*  -# Signature verifying
***************************************************************/
CE2Error_t LLF_ECDSA_Verify (
  CE2_ECPKI_UserPublKey_t       *UserPublKey_ptr,        /*in*/
  CE2_ECPKI_HASH_OpMode_t        HashMode,               /*in*/
  DxUint8_t                      *SignatureIn_ptr,        /*in*/
  DxUint32_t                      SignatureSizeBytes,     /*in*/
  DxUint8_t                      *MessageDataIn_ptr,      /*in*/ 
  DxUint32_t                      MessageSizeInBytes      /*in*/ );

#ifdef __cplusplus
}
#endif

#endif
